/*====================================================================================
 
	Sonique Visual Plugin API

        (c) 1999 Sonique Team

		edited as applies to Shareaza.

	Notes:	
		*Video points to memory in 32bit video memory, ie, the following can be used
		for your utility and to help your understanding of the pixel format used.

====================================================================================*/

#define ALPHA_MASK	0xFF000000
#define RED_MASK	0x00FF0000
#define GREEN_MASK	0x0000FF00
#define BLUE_MASK	0x000000FF

#define ALPHA_SHIFT	24
#define RED_SHIFT	16
#define GREEN_SHIFT 8
#define BLUE_SHIFT	0

#define AlphaByte(x)			(((x))>>ALPHA_SHIFT)
#define RedByte(x)				(((x) & RED_MASK)>>RED_SHIFT)
#define GreenByte(x)			(((x) & GREEN_MASK)>>GREEN_SHIFT)
#define BlueByte(x)				(((x) & BLUE_MASK)>>BLUE_SHIFT)
#define MakeColour(a, r, g, b)	(((a)>>ALPHA_SHIFT) + ((r & RED_MASK)>>RED_SHIFT) + ((g & GREEN_MASK)>>GREEN_SHIFT) + ((b & BLUE_MASK)>>BLUE_SHIFT))

#ifndef DLLEXPORT
#define DLLEXPORT    __declspec( dllexport )
#endif

#define VI_WAVEFORM			0x0001		/* set if you need the waveform */
#define VI_SPECTRUM			0x0002		/* set if you need the FFT values */
#define SONIQUEVISPROC		0x0004		/* set if you want to allow Sonique user pref effects (Unavailable) */

#pragma pack (push, 8)

typedef struct 
{
	unsigned long	MillSec;			/* Sonique sets this to the time stamp of end this block of data */
	unsigned char	Waveform[2][512];	/* Sonique sets this to the PCM data being outputted at this time */
	unsigned char	Spectrum[2][256];	/* Sonique sets this to a lowfidely version of the spectrum data 
										   being outputted at this time
										   0 (bass) -> 255 (treble) */
} 
VisData;

typedef struct
{
	unsigned long Reserved;				/* Reserved */

	char	*PluginName;				/* Name of the Plug-In */ 
	long	lRequired;					/* Which flags (VI_WAVEFORM|VI_SPECTRUM|SONIQUEVISPROC) to set */
	void	(*Initialize)(void);		/* Called before Plug-In has to Render */
	BOOL	(*Render)( unsigned long *Video, int width, int height, int pitch, VisData* pVD); /* Function called to Render */
	BOOL	(*SaveSettings)( char* FileName );	/* Function called to Save the Settings */
	BOOL	(*OpenSettings)( char* FileName );	/* Function called to Open the Settings */
} 
VisInfo;

#pragma pack (pop, 8)

DLLEXPORT VisInfo* QueryModule(void);	/* exported DLL */

